#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

#define NB_CUBES (150)
#define SIZE_OF_CUBE (50.f)

#define FOG_COLOR (0)

#define ABS(X) (((X)>0)?(X):-(X))

static Obj3d CubesTab[NB_CUBES];
static float CoorX[] = {-SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE, -SIZE_OF_CUBE,
							-SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE, -SIZE_OF_CUBE};
static float CoorY[] = {-SIZE_OF_CUBE, -SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE,
							-SIZE_OF_CUBE, -SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE};
static float CoorZ[] = {-SIZE_OF_CUBE, -SIZE_OF_CUBE, -SIZE_OF_CUBE, -SIZE_OF_CUBE,
							SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE, SIZE_OF_CUBE};

static Face FaceList[] = {
	{0,1,2, 0, 0, 256, 0, 256, 256},
	{2,3,0, 256, 256, 0, 256, 0, 0},
	{1,5,6, 0, 0, 256, 0, 256, 256},
	{6,2,1, 256, 256, 0, 256, 0, 0},
	{4,5,1, 0, 0, 256, 0, 256, 256},
	{1,0,4, 256, 256, 0, 256, 0, 0},
	{4,0,3, 0, 0, 256, 0, 256, 256},
	{3,7,4, 256, 256, 0, 256, 0, 0},
	{5,4,7, 0, 0, 256, 0, 256, 256},
	{7,6,5, 256, 256, 0, 256, 0, 0},
	{3,2,6, 0, 0, 256, 0, 256, 256},
	{6,7,3, 256, 256, 0, 256, 0, 0}
};

static Vector Pos[NB_CUBES];
//static Vector Rot[NB_CUBES];
static IntVector Rot[NB_CUBES];

static float Matrix[16], Matrix2[16];

void LInit_Cubes()
{
	float RatioX, RatioY, RatioZ;
	float Reste;
	int Cpt1, Cpt2;

	srand((unsigned)time(NULL));

	for(Cpt1=0;Cpt1<NB_CUBES;Cpt1++)
	{
		CubesTab[Cpt1].pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*8);
		CubesTab[Cpt1].pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*8);
		CubesTab[Cpt1].NbVertex = 8;
		CubesTab[Cpt1].pFace = FaceList;
		CubesTab[Cpt1].NbFaces = 12;

		Reste = 0;

		RatioX = ((rand()%1000)+500)/1000.f;
		RatioY = ((rand()%1000)+500)/1000.f;
		RatioZ = ((rand()%1000)+500)/1000.f;


		// vertexes
		for(Cpt2=0;Cpt2<8;Cpt2++)
		{
			
			// with deform
			/*CubesTab[Cpt1].pVertexIn[Cpt2].x = CoorX[Cpt2] * ((rand()%1000)+500)/1000.f;
			CubesTab[Cpt1].pVertexIn[Cpt2].y = CoorY[Cpt2] * ((rand()%1000)+500)/1000.f;
			CubesTab[Cpt1].pVertexIn[Cpt2].z = CoorZ[Cpt2] * ((rand()%1000)+500)/1000.f;*/

			// no deform
			CubesTab[Cpt1].pVertexIn[Cpt2].x = CoorX[Cpt2];
			CubesTab[Cpt1].pVertexIn[Cpt2].y = CoorY[Cpt2];
			CubesTab[Cpt1].pVertexIn[Cpt2].z = CoorZ[Cpt2];

			CubesTab[Cpt1].pVertexOut[Cpt2].r = (float)(rand()&127);
			CubesTab[Cpt1].pVertexOut[Cpt2].g = (float)(rand()&127);
			CubesTab[Cpt1].pVertexOut[Cpt2].b = (float)(rand()&127);
		}

		do{
			Pos[Cpt1].x = (float)( (rand()%1500) - 750 );
			Pos[Cpt1].y = (float)( (rand()%1500) - 750 );
		}while (sqrt(Pos[Cpt1].x * Pos[Cpt1].x + Pos[Cpt1].y * Pos[Cpt1].y)<75);
		Pos[Cpt1].z = (float)(rand()&4095);

		Rot[Cpt1].x = (rand()&1023); // /300.f
		Rot[Cpt1].y = (rand()&1023);
		Rot[Cpt1].z = (rand()&1023);
	}

	PrepareTextureFromArray(g_PicTour, 256, 256, &g_TextureTour);
}

void QInit_Cubes()
{
	grConstantColorValue(255);

	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grCullMode(GR_CULL_NEGATIVE);

	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0x33aa33);
	grFogTable(g_FogCubeField);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);

	DownloadTexture(&g_TextureTour);
	SelectTexture(g_TextureTour);

	grSstControl(GR_CONTROL_ACTIVATE);
}

void Effect_Cubes()
{
	static Vector Pos1;
	static Vector Rot1;
	static float TransX, TransY;
	static DWORD nOld = 0;
	static DWORD nProgress;
	
	int Cpt1;
	int Img1;
	DWORD fog_color;

	Img1 = g_demostate.TickInEffect/10;
	nProgress = (g_demostate.TickInEffect - nOld)*2;
	//nProgress = (DWORD)sqrt(g_demostate.TickInEffect>>2);

	TransX = 1.5f * (float)cos(Img1/50.f);
	TransY = 1.5f * (float)sin(Img1/50.f);

	//fog_color = (DWORD)(64+63*cos(Img1/10.f));
	//fog_color = (fog_color>>1)+(fog_color<<8)+((fog_color>>1)<<16);
	fog_color = 0;
	grFogColorValue(fog_color);
	g_demostate.ClearColor = fog_color;

	for(Cpt1=0;Cpt1<NB_CUBES;Cpt1++)
	{
		//Pos[Cpt1].z -= 3;
		//Pos[Cpt1].z -= cos(Img1/10.f)*20 + 16;
		Pos[Cpt1].z -= cos(Img1/10.f)*30 + 24;
		//Pos[Cpt1].z -= 30.f;
		//Pos[Cpt1].z -= nProgress;

		if (Pos[Cpt1].z < 0)
			Pos[Cpt1].z = 4000;

		Rot[Cpt1].x += 20; // +0.01
		Rot[Cpt1].y += 22; // +0.011

		Pos[Cpt1].x += TransX;
		Pos[Cpt1].y += TransY;

		BeIdentityMatrix(Matrix);
		RotateXMatrix(Matrix2, Matrix, Rot[Cpt1].x);
		RotateYMatrix(Matrix, Matrix2, Rot[Cpt1].y);
		RotateZMatrix(Matrix2, Matrix, Rot[Cpt1].z);
		TranslateMatrix(Matrix2, Pos[Cpt1].x, Pos[Cpt1].y, Pos[Cpt1].z);

		DrawWithMatrixSowTow(&CubesTab[Cpt1], Matrix2, 0, 0);
	}

	nOld = g_demostate.TickInEffect;
}

void ByeBye_Cubes()
{


}
